/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.util;

import com.ibm.hwmca.fw.rcs.RcsObject;
import com.ibm.hwmca.fw.rcs.util.RcsException;
import com.ibm.hwmca.fw.rcs.util.RcsModemListener;
import com.ibm.hwmca.fw.rcs.util.RcsTrace;
import com.ibm.hwmca.fw.util.RootProcess;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RcsModemControl
extends RcsObject {
    public static final int MODEM_SUCCESS = 0;
    public static final int MODEM_ERROR_BAD_USAGE = 1;
    public static final int MODEM_ERROR_INVALID_MODE = 2;
    public static final int MODEM_ERROR_FAILED_TO_INIT_MODEM = 10;
    public static final int MODEM_ERROR_FAILED_TO_RESET_MODEM = 11;
    public static final int MODEM_ERROR_DURING_MODEM_RING = 12;
    public static final int MODEM_ERROR_FAILED_TO_LOCK_MODEM = 13;
    public static final int MODEM_ERROR_GENERIC_MODEM_FAILURE = 14;
    public static final int MODEM_ERROR_MODEM_NO_CARRIER = 15;
    public static final int MODEM_ERROR_MODEM_ERROR = 16;
    public static final int MODEM_ERROR_MODEM_NO_DIALTONE = 17;
    public static final int MODEM_ERROR_MODEM_BUSY = 18;
    public static final int MODEM_ERROR_MODEM_NO_ANSWER = 19;
    public static final int MODEM_ERROR_UNEXPECTED_FAILURE = 20;
    public static final int MODEM_ERROR_JAVA = 50;
    public static final int MODEM_ERROR_SPAWN = 60;
    public static final int MODEM_ERROR_CHILD = 70;
    public static final int MODEM_ERROR_TIMEOUT = 300;
    private static RcsModemControl instance;
    public static final int DIAL_TIMEOUT = 300000;
    private boolean dialActive = false;
    private Process dialProcess = null;
    private Object dialLock = new Object();
    private int dialRc;
    private BufferedReader dialOut;
    private BufferedReader dialErr;
    public static final int MONITOR_TIMEOUT = 300000;
    private boolean monitorActive = false;
    private Set modemListeners = new HashSet();
    private Process monitorProcess = null;
    private Object monitorLock = new Object();
    private int monitorRc;
    private BufferedReader monitorOut;
    private BufferedReader monitorErr;

    private RcsModemControl() {
    }

    public static synchronized RcsModemControl getInstance() {
        return instance;
    }

    public boolean isDialRunning() {
        return this.dialProcess != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startDial(String number) throws RcsException {
        this.ttrace("--> startDial( " + number + " )");
        int rc = 0;
        Object object = this.dialLock;
        synchronized (object) {
            block11: {
                if (this.dialProcess != null) {
                    throw new RcsException("Modem is already in the process of dialing.");
                }
                try {
                    String mDevice = "/dev/modem";
                    String mInitString = "ATS7=45S0=0L1V1X4&c1E1Q0";
                    String mDialString = number;
                    String mProgram = "rcsModemControlExec --mode dial --device " + mDevice + " --init " + mInitString + " --dialstring " + mDialString;
                    this.dtrace("Attempting to launch: " + mProgram);
                    this.dialProcess = RootProcess.startProgram(mProgram);
                    this.dialOut = new BufferedReader(new InputStreamReader(this.dialProcess.getInputStream()));
                    this.dialErr = new BufferedReader(new InputStreamReader(this.dialProcess.getErrorStream()));
                    new Thread("RcsModemControl.startDial()"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            while (RcsModemControl.this.dialProcess != null) {
                                try {
                                    RcsModemControl.this.dialRc = RcsModemControl.this.dialProcess.waitFor();
                                    RcsModemControl.this.dialProcess = null;
                                }
                                catch (InterruptedException e) {
                                    RcsModemControl.this.ftrace("dialProcess interrupted: " + e);
                                }
                            }
                            RcsModemControl.this.ftrace("dialProcess finished with rc: " + RcsModemControl.this.dialRc);
                            Object object = RcsModemControl.this.dialLock;
                            synchronized (object) {
                                RcsModemControl.this.dialLock.notifyAll();
                            }
                        }
                    }.start();
                    long timestamp = System.currentTimeMillis();
                    do {
                        try {
                            this.ttrace("sleeping...");
                            this.dialLock.wait(300000L);
                            this.ttrace("waking...");
                        }
                        catch (InterruptedException e) {
                            this.ftrace("startDial thread was interrupted: " + e);
                        }
                        if (this.dialProcess == null) {
                            rc = this.dialRc;
                        } else {
                            if (!this.isDialActive()) continue;
                            rc = 0;
                        }
                        break block11;
                    } while (System.currentTimeMillis() - timestamp <= 300000L);
                    this.stopDial();
                    rc = 300;
                }
                catch (Exception e) {
                    this.logInfoError("Exception occurred during dial.", e);
                }
            }
        }
        this.ttrace("<-- startDial() [" + rc + "] ");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDial() {
        this.ttrace("--> stopDial()");
        Object object = this.dialLock;
        synchronized (object) {
            if (this.dialProcess != null) {
                this.ttrace("Destroying dialProcess.");
                this.dialProcess.destroy();
                this.dialProcess = null;
            }
            this.dialActive = false;
        }
        this.ttrace("<-- stopDial()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateDial() {
        this.ttrace("<-> activateDial()");
        this.dialActive = true;
        Object object = this.dialLock;
        synchronized (object) {
            this.dialLock.notifyAll();
            while (this.isDialActive()) {
                try {
                    this.dialLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.ftrace("activateDial thread was interrupted: " + e);
                }
            }
        }
    }

    private boolean isDialActive() {
        if (this.dialProcess == null) {
            this.dialActive = false;
        }
        return this.dialActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModemListener(RcsModemListener listener) {
        Object object = this.monitorLock;
        synchronized (object) {
            this.modemListeners.add(listener);
            try {
                this.startMonitor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModemListener(RcsModemListener listener) {
        Object object = this.monitorLock;
        synchronized (object) {
            this.modemListeners.remove(listener);
            if (this.modemListeners.isEmpty()) {
                this.stopMonitor();
            }
        }
    }

    public boolean isMonitorRunning() {
        return this.monitorProcess != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startMonitor() throws RcsException {
        this.ttrace("--> startMonitor()");
        int rc = 0;
        Object object = this.monitorLock;
        synchronized (object) {
            block11: {
                if (this.monitorProcess != null) {
                    throw new RcsException("Modem is already monitoring the phone line.");
                }
                try {
                    String mDevice = "/dev/modem";
                    String mInitString = "ATS7=45S0=0L1V1X4&c1E1Q0";
                    String mProgram = "rcsModemControlExec --mode monitor --device " + mDevice + " --init " + mInitString;
                    this.dtrace("Attempting to launch: " + mProgram);
                    this.monitorProcess = RootProcess.startProgram(mProgram);
                    this.monitorOut = new BufferedReader(new InputStreamReader(this.monitorProcess.getInputStream()));
                    this.monitorErr = new BufferedReader(new InputStreamReader(this.monitorProcess.getErrorStream()));
                    new Thread("RcsModemControl.startMonitor"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = RcsModemControl.this.monitorLock;
                            synchronized (object) {
                                while (RcsModemControl.this.monitorProcess != null) {
                                    try {
                                        RcsModemControl.this.monitorRc = RcsModemControl.this.monitorProcess.waitFor();
                                        RcsModemControl.this.monitorProcess = null;
                                    }
                                    catch (InterruptedException e) {
                                        RcsModemControl.this.ttrace("monitorProcess interrupted: " + e);
                                    }
                                }
                                RcsModemControl.this.ftrace("monitorProcess finished with rc: " + RcsModemControl.this.monitorRc);
                                RcsModemControl.this.monitorLock.notifyAll();
                            }
                        }
                    }.start();
                    long timestamp = System.currentTimeMillis();
                    do {
                        try {
                            this.monitorLock.wait(300000L);
                        }
                        catch (InterruptedException e) {
                            this.ftrace("startMonitor thread was interrupted: " + e);
                        }
                        if (this.monitorProcess == null) {
                            rc = this.monitorRc;
                        } else {
                            if (!this.monitorActive) continue;
                            rc = 0;
                        }
                        break block11;
                    } while (System.currentTimeMillis() - timestamp <= 300000L);
                    this.stopMonitor();
                    rc = 300;
                }
                catch (Exception e) {
                    this.logError(e);
                }
            }
        }
        this.ttrace("<-- startMonitor() [" + rc + "]");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitor() {
        this.ttrace("--> stopMonitor()");
        Object object = this.monitorLock;
        synchronized (object) {
            if (this.monitorProcess != null) {
                this.monitorProcess.destroy();
                this.monitorProcess = null;
            }
        }
        this.ttrace("<-- stopMonitor()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateMonitor() {
        this.ttrace("<-> activateMonitor()");
        Object object = this.monitorLock;
        synchronized (object) {
            this.monitorActive = true;
            this.monitorLock.notifyAll();
        }
    }

    private boolean isMonitorActive() {
        if (this.monitorProcess == null) {
            this.monitorActive = false;
        }
        return this.monitorActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModemToBeAnswered() {
        Object object = this.monitorLock;
        synchronized (object) {
            Iterator i = this.modemListeners.iterator();
            while (i.hasNext()) {
                if (!((RcsModemListener)i.next()).isModemToBeAnswered()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modemAnswered() {
        Object object = this.monitorLock;
        synchronized (object) {
            Iterator i = this.modemListeners.iterator();
            while (i.hasNext()) {
                ((RcsModemListener)i.next()).modemAnswered();
            }
        }
    }

    static {
        try {
            instance = new RcsModemControl();
        }
        catch (Exception e) {
            RcsTrace.logInfoError("RcsModemControl.static Exception", e);
        }
    }
}

